;** ###################################################################
;**     This code is generated by the Device Initialization Tool.
;**     It is overwritten during code generation.
;**     USER MODIFICATION ARE PRESERVED ONLY INSIDE INTERRUPT SERVICE ROUTINES
;**
;**     Project   : KA2_Test1
;**     Processor : MC9RS08KA2CPC
;**     Version   : Bean 01.059, Driver 01.00, CPU db: 2.87.060
;**     Datasheet : MC9RS08KA2 Rev. 2 12/2006
;**     Date/Time : 20.9.2007, 12:42
;**     Abstract  :
;**         This module contains device initialization code 
;**         for selected on-chip peripherals.
;**     Contents  :
;**         Function "MCU_init" initializes selected peripherals
;**
;**     (c) Copyright UNIS, spol. s r.o. 1997-2006
;**     UNIS, spol s r.o.
;**     Jundrovska 33
;**     624 00 Brno
;**     Czech Republic
;**     http      : www.processorexpert.com
;**     mail      : info@processorexpert.com
;** ###################################################################

        INCLUDE MC9RS08KA2.inc         ; I/O map for MC9RS08KA2CPC

CODE_SECT:      SECTION

        XDEF    MCU_init
;** ===================================================================
;**     Method      :  MCU_init (bean MC9RS08KA2_8)
;**
;**     Description :
;**         Device initialization code for selected peripherals.
;** ===================================================================
MCU_init:
  ; ### MC9RS08KA2_8 "Cpu" init code ... 
  ; Common initialization of the write once registers 
        ; SOPT: COPE=1,COPT=1,STOPE=1,BKGDPE=0,RSTPE=0 
        MOV     #HIGH_6_13(SOPT),PAGESEL ; Set page register
        MOV     #$E0,MAP_ADDR_6(SOPT)                          
        ; SPMSC1: LVDF=0,LVDACK=0,LVDIE=0,LVDRE=1,LVDSE=1,LVDE=1,BGBE=0 
        MOV     #HIGH_6_13(SPMSC1),PAGESEL ; Set page register
        MOV     #$1C,MAP_ADDR_6(SPMSC1)                          
  ;  System clock initialization 
        ; ICSTRM: Initialize internal clock trim from a non volatile memory 
        MOV     #$FF,PAGESEL           ; Set page register
        LDA     $FA                    ; constant address $3FFA
        STA     ICSTRM
        ; ICSSC: Initialize internal clock trim from a non volatile memory 
        MOV     #$FF,PAGESEL           ; Set page register
        LDA     $FB                    ; constant address $3FFB
        STA     ICSSC
        ; ICSC1: CLKS=0,IREFSTEN=1 
        MOV     #$01,ICSC1             ; Initialization of the ICS control register 1 
        ; ICSC2: BDIV=0,LP=0 
        CLR     ICSC2                  ; Initialization of the ICS control register 2 
  ; Common initialization of the CPU registers 
        ; PTAPE: PTAPE5=1,PTAPE4=1,PTAPE2=1,PTAPE1=1 
        MOV     #HIGH_6_13(PTAPE),PAGESEL ; Set page register
        LDA     MAP_ADDR_6(PTAPE)
        ORA     #$36
        STA     MAP_ADDR_6(PTAPE)
        ; PTAPUD: PTAPUD5=0,PTAPUD4=0,PTAPUD2=0,PTAPUD1=0 
        MOV     #HIGH_6_13(PTAPUD),PAGESEL ; Set page register
        LDA     MAP_ADDR_6(PTAPUD)
        AND     #$C9
        STA     MAP_ADDR_6(PTAPUD)
        ; PTASE: PTASE5=1,PTASE4=1,PTASE3=1,PTASE1=1,PTASE0=0 
        MOV     #HIGH_6_13(PTASE),PAGESEL ; Set page register
        LDA     MAP_ADDR_6(PTASE)
        AND     #$FE
        ORA     #$3A
        STA     MAP_ADDR_6(PTASE)
  ; ### Init_KBI init code 
        ; KBISC: KBIE=0 
        BCLR    $01,KBISC
        ; KBIES: KBEDG5=0,KBEDG4=0,KBEDG2=0,KBEDG1=0,KBEDG0=0 
        CLR     KBIES                                
        ; KBISC: KBIMOD=0 
        BCLR    $00,KBISC
        ; KBIPE: KBIPE5=1,KBIPE4=1,KBIPE2=1,KBIPE1=1,KBIPE0=0 
        MOV     #$36,KBIPE                          
        ; KBISC: KBACK=1 
        BSET    $02,KBISC
        ; KBISC: KBIE=1 
        BSET    $01,KBISC
  ; ### Init_COP init code 
        MOV     #HIGH_6_13(SRS),PAGESEL ; Set page register
        MOV     #$FF,MAP_ADDR_6(SRS)   ; Clear WatchDog counter 
  ; ### Init_GPIO init code 
        ; PTAD: PTAD3=0,PTAD0=1 
        LDA     PTAD
        AND     #$F7
        ORA     #$01
        STA     PTAD
        ; PTAPUD: PTAPUD0=0 
        MOV     #HIGH_6_13(PTAPUD),PAGESEL ; Set page register
        BCLR    $00,MAP_ADDR_6(PTAPUD)
        ; PTAPE: PTAPE0=0 
        MOV     #HIGH_6_13(PTAPE),PAGESEL ; Set page register
        BCLR    $00,MAP_ADDR_6(PTAPE)
        ; PTADD: PTADD0=1 
        BSET    $00,PTADD
  ; ### 
        RTS



; Initialization of the CPU registers in FLASH 

        ; NVOPT: SECD=1 
        ORG     NVOPT
        DC.B    $FF


; Reset vector is JUMP instruction 
        XREF    _Startup
        ORG     $3FFD                  ; MCU after reset point
        JMP     _Startup               ; reset vector

        END

;** ###################################################################
;**
;**     This file was created by UNIS Processor Expert 3.00 [03.89]
;**     for the Freescale RS08 series of microcontrollers.
;**
;** ###################################################################
